import numpy as np
from math import *
import define_experiment as exp
import scipy.interpolate as sci
import subfunctions as sf
import matplotlib.pyplot as plt


rover = {'wheel_assembly': {'wheel': {'radius': 0.3, 'mass': 1},
                            'speed_reducer': {'type': 'reverted', 'diam_pinion': 0.05, 'diam_gear': 0.08, 'mass': 1.50},
                            'motor': {'torque_stall': 175, 'torque_noload': 0, 'speed_noload': 3.9, 'mass': 5,
                                      'effcy_tau': np.array([0, 10, 20, 40, 70, 165]), 'effcy': np.array([0, 0.55, 0.75, 0.71, 0.5, 0.05])}},
         'chassis': {'mass': 659}, 'science_payload': {'mass': 75}, 'power_subsys': {'mass': 90}}
planet = {'g': 3.72}
experiment1 = exp.experiment1()
experiment = experiment1[0]
end_event = experiment1[1]

angle = experiment['alpha_deg']
distance = experiment['alpha_dist']
dist = np.linspace(min(experiment['alpha_dist']), max(experiment['alpha_dist']), 100)
deg = []
alpha_fun = sci.interp1d(experiment['alpha_dist'], experiment['alpha_deg'], kind = 'cubic', fill_value='extrapolate') # fit the cubic spline

for i in range(len(dist)):
    deg_val = alpha_fun(dist[i].item())
    deg.append(deg_val)

plt.plot(dist, deg, 'k-')
plt.plot(distance, angle, 'r*')
plt.xlabel('Position (m)')
plt.ylabel('Terrain Angle (radian)')
plt.show()

